/* --------------------------------------------------------
                     tm1650_demo.ino

     Demo fuer 4-stellige 7-Segmentanzeige mit TM1650
     LED-Controller

     23.05.2025 R. Seelig
   -------------------------------------------------------- */

#include "tm16xx.h"

// disp(clk, data, displaytype)
// fuer den CH32V003 entspricht in Arduino 4 = PC2
//                                         3 = PC1

tm16xx  disp(4,3,TM1650_CTRL);

#define my_led    A7
#define speed1    80
#define speed2    910

void setup()
{
  pinMode(my_led, OUTPUT);
  disp.begin();
  disp.clear();
  disp.setbright(5);
}

int cx   = 1000;

void loop()
{

  digitalWrite(my_led, 1);   
  delay(speed1);                       
  digitalWrite(my_led, 0);    
  delay(speed2);                      
  disp.setdez_nonull(cx,0);
  cx++;
  cx %= 10000;
}
