/* ------------------------------------------------------------------
                              tm16xx.h

     Grundfunktionen eines TM16xx, Treiberbaustein fuer 4 und 6
     stellige 7-Segmentanzeigen mit gemeinsamer Anode und
     zusaetzlichem Tasteninterface.

     Geeignet fuer: TM1650, TM1651, TM1637

     21.05.2025 R. Seelig
   ------------------------------------------------------------------ */

#ifndef in_tm16xx
  #define in_tm16xx

  #include "Arduino.h"

  enum LEDCONTROLLER {TM1637_CTRL, TM1651_CTRL, TM1650_CTRL};

  class tm16xx
  {

    #define scl_init()    pinMode(tm16_scl, INPUT)
    #define sda_init()    pinMode(tm16_sda, INPUT)
    #define bb_scl_hi()   scl_init()
    #define bb_scl_lo()   { pinMode(tm16_scl, OUTPUT);  digitalWrite(tm16_scl, LOW); }
    #define bb_sda_hi()   sda_init()
    #define bb_sda_lo()   { pinMode(tm16_sda, OUTPUT);  digitalWrite(tm16_sda, LOW); }
    #define bb_is_sda()   digitalRead(tm16_sda)

    #define puls_us        10
    #define puls_len()     delayMicroseconds(puls_us)

  public:
    tm16xx(uint8_t scl, uint8_t sda, uint8_t CTRLTYPE);

    void clear();
    void begin();
    void selectpos(int8_t nr);
    void setbright(uint8_t value);
    void setbmp(uint8_t pos, uint8_t value);
    void setzif(uint8_t pos, uint8_t zif);
    void setseg(uint8_t pos, uint8_t seg);
    void setdez(int value, uint8_t dpanz);
    void setdez_nonull(int value, uint8_t dpanz);
    void setdez2(char pos, int8_t value);
    void sethex(uint16_t value);
    void sethex2(char pos, uint8_t value);
    void setdez6digit(uint32_t value, uint8_t dpanz);
    void setdez6digit_nonull(int32_t value, uint8_t dpanz);
    void sethex6digit(uint32_t value);
    uint8_t readkey(void);

  protected:

  private:
    uint8_t   hellig     = 1;                 // beinhaltet Wert fuer die Helligkeit (erlaubt: 0x00 .. 0x0f);
    uint8_t   tm16_scl;
    uint8_t   tm16_sda;

    int8_t tm16_xofs     = 0;

    uint8_t   ctrl_type  = 0;

    void start();
    void stop();
    void write (uint8_t value);
    uint8_t read(uint8_t ack);
};

#endif
